<?php
/*
The Golden Fox
ver 1.0 by kryuu => kamil -at- ryuu -dot- eu
06 Jun 2024

The module introduces the character of a golden fox who asks for money.

The user has two options - we can give him gold or rob him. If we give
the fox gold, he doubles the gold after each fight.

Stealing is a simple way to make quick money, but there is a small
chance that we will not succeed. Then the fox will take from us all
the money we robbed. If we don't have enough, we will be burdened
with a debt to the bank.
*/

// translator ready
// mail ready
// addnews ready
function goldenfox_getmoduleinfo(){
	$info = array(
		"name"=>"Golden Fox",
		"version"=>"1.0",
		"author"=>"kryuu",
		"category"=>"Forest Specials",
		"download"=>"https://lotgd.ryuu.eu/modules/download/goldenfox.zip",

		"settings"=>array(
			"Golden Fox - Settings,title",
			"maxdebt"=>"Maximum amount of stolen gold from fox,int|10000",
		),
		"prefs"=>array(
			"Golden Fox - User Preferences,title",
			"stolen"=>"How much gold user has stolen,int|0",
			"curse"=>"How much gold left in curse?,int|0",
		)
	);
	return $info;
}

function goldenfox_install(){
	module_addeventhook("forest", "return 100;");
	module_addhook("creatureencounter");
	module_addhook("alter-gemchance");
	module_addhook("footer-forest");
	return true;
}

function goldenfox_uninstall(){
	return true;
}

function goldenfox_dohook($hookname, $args){
	global $session, $gold_before;

	switch ($hookname) {
		case "creatureencounter":
			$stolen = get_module_pref("stolen");
			$curse = get_module_pref("curse");
			$mod = ($curse > 0 ? 0.25 : ($stolen < 0 ? 2.0 : 1.0));
			$args['creaturegold'] = round($args['creaturegold'] * $mod, 0);
			break;
		case 'alter-gemchance':
			$gold_before = $session['user']['gold'];
			$stolen = get_module_pref("stolen");
			$curse = get_module_pref("curse");

			if ($curse > 0) {
				output("`\$You receive 75%% less gold due to the `Qgolden fox`\$ curse! `2(%d gold left)`n", $curse);
			} else if ($stolen < 0) {
				output("`^You receive twice as much gold thanks to the `Qgolden fox`^ blessing! `2(%d gold left)`n", -$stolen);
			}
			break;
		case 'footer-forest':
			if ($gold_before == '') {
				break;
			}
			$stolen = get_module_pref("stolen");
			$curse = get_module_pref("curse");
			$gold_change = $session['user']['gold'] - $gold_before;

			if ($curse > 0) {
				set_module_pref("curse", max(0, $curse - (3 * $gold_change)));
			} else if ($stolen < 0) {
				set_module_pref("stolen", min(0, $stolen + round($gold_change / 2)));
			}
			break;
	}

	return $args;
}

function goldenfox_runevent($type, $link)
{
	global $session;

	$from = "forest.php";
	$runmodule = "runmodule.php?module=goldenfox&";

	output("`3Wandering through the forest, you came to a clearing. In the middle of it sits a small, `Qgolden fox`3. The creature was playing with coins, and next to it lay a large purse filled with gold.`n`n");
	output("`^\"Hello there,\"`3 the fox said. `^\"Travellers pass by and offer me their gold, and I wish them luck. Would you mind giving me some of your gold?\"");

	addnav("Give gold",$runmodule."op=give");
	addnav("Steal gold",$runmodule."op=steal");

	if ($session['user']['gold'] < 1000 || $session['user']['goldinbank'] < 0) {
		addnav("Ask for gold",$runmodule."op=help");
	}

	addnav("Ignore fox",$from);
}

function goldenfox_include_form() {
	require_once("lib/showform.php");

	$runmodule = "runmodule.php?module=goldenfox&";

	rawoutput("<form action='".$runmodule."op=give_submitted' method='POST'>");
	showform(array("amount"=>"How much gold do you give to the fox,int"), array(), true);
	addnav("", $runmodule."op=give_submitted");
	$give = translate_inline("Give");
	rawoutput("<input type='submit' class='button' value='$give'>");
	rawoutput("</form><br>");
}


function goldenfox_run(){
	global $session;

	$from = "forest.php";
	$runmodule = "runmodule.php?module=goldenfox&";
	$op = httpget('op');

	page_header("The golden fox");

	if ($op === 'give') {
		output("`3You reach into your pocket to decide how much gold to give to the fox.`n`n");
		output("`^\"Yes, yes, give me gold.\"`3 The fox chuckles happily.");
		goldenfox_include_form();

		addnav("Steal gold instead", $runmodule."op=steal");
		addnav("Leave", $from);
	}

	else if ($op === 'give_submitted') {
		$amount = httppost('amount');
		
		if ($amount > $session['user']['gold'] || $amount <= 0) {
			output("`3You take a long time deciding the amount, the fox becomes uneasy.`n`n");
			output("`^\"Wanna give me the gold or not?\"");
			goldenfox_include_form();

			addnav("Steal gold instead", $runmodule."op=steal");
			addnav("Leave", $from);
		}

		else {
			$lost_gold = $amount;
			$session['user']['gold'] -= $amount;
			
			if ($amount < $session['user']['level'] * 100) {
				output("`3The fox is a little dissappointed by the small amount of coins.`n`n");
				$amount = 0;
			}

			$amount = 2 * $amount;
			$stolen = get_module_pref("stolen");
			$curse = get_module_pref("curse");

			$new_curse = $curse - $amount;
			$new_stolen = $stolen;
			if ($new_curse < 0) {
				$new_stolen += $new_curse;
				$new_curse = 0;
			}

			output("`3The fox hugs the coins you gave him. ");

			if ($new_curse > 0) {
				output("`^\"You are still in my debt, but it should weaken the curse that is upon you.\"");
			} else if ($new_stolen > 0) {
				output("`^\"This amount does not compensate for the losses I have suffered, but thank you for your contribution.\"");
			} else if ($stolen > 0 && $new_stolen <= 0) {
				output("`^\"Alright, then we are even. May luck be on your side now, traveler.\"");
			} else {
				output("`^\"You are a good traveler. May luck be with you.\"");
			}

			output("`3Then he returns to playing with the coins.`n`n");

			set_module_pref("curse", $new_curse);
			set_module_pref("stolen", $new_stolen);

			output("`\$You lose %d gold!`n", $lost_gold);
			debuglog("donated $lost_gold gold to the golden fox");
			addnav("Continue", $from);
		}
	}

	else if ($op === 'steal') {
		output("`3You take out your `%%s`3 and approach the fox. The creature begs for mercy. ", $session['user']['weapon']);
		output("`^\"Please, do not hurt me or take my gold. It will bring you bad luck.\"`n`n");

		$maxdebt = get_module_setting("maxdebt");
		$stolen = get_module_pref("stolen");

		$random = e_rand(0, $maxdebt);

		if ($random < $stolen) {
			output("`3You are only a few steps away from the creature, but you lose your balance, "
				."trip and hit your head on a tree. You lie on the ground completely numb, "
				."and the fox stands over you, sniffing you.`n`n");

			output("`^\"It was very unwise to steal from me. Now you have to return everything you took from me. "
				."Now, let me take %d gold from you.\"`n`n", $stolen);

			output("`3You lose consciousness, and when you open your eyes, the fox is no longer nearby.`n`n");
			
			$lost_gold = $stolen;
			if ($lost_gold > $session['user']['gold']) {
				$lost_gold = $session['user']['gold'];
			}

			$session['user']['gold'] -= $lost_gold;
			output("`\$You lose %d gold!`n", $lost_gold);

			if ($lost_gold < $stolen) {
				$lost_goldinbank = $stolen - $lost_gold;
				$session['user']['goldinbank'] -= $lost_goldinbank;
				output("`\$Your bank account has been charged with %d gold!`n", $lost_goldinbank);
			}

			debuglog("was cursed by the golden fox ($stolen gold)");
			$curse = get_module_pref("curse");
			set_module_pref("curse", $curse + $stolen);
			set_module_pref("stolen", 0);
		}


		else {
			output("`3However, you do not react to his words and continue approaching. "
				."The fox runs away in fear, leaving all the gold behind. "
				." You managed to gain a lot of gold, it was easier than you expected.`n`n");

			$maxdebt_by_5 = round($maxdebt / 5);
			$gain_gold = $maxdebt_by_5 + e_rand(0, $maxdebt_by_5);
			$session['user']['gold'] += $gain_gold;
			output("`^You gain %d gold!`n", $gain_gold);
			debuglog("stole $gain_gold gold from the golden fox");
			set_module_pref("stolen", $stolen + $gain_gold);
		}

		addnav("Continue", $from);
	}


	else if ($op === 'help') {
		output("`3You explain to the fox that you have very little gold and ask if he could help you.`n`n");
		output("`^\"Are you looking for help?\"`3 The fox approached you and sniffed you carefully.`n`n");

		if ($session['user']['goldinbank'] < 0) {
			output("`^\"Oh yes, I can smell your debts to the bank. I will help you.\"`3 The fox smiled broadly.`n`n");
			output("`3A moment later your body was paralyzed and you were lying motionless on the ground. The fox touched your forehead with his paw and muttered some spell, and then you lost consciousness.`n`n");
			output("`3When you opened your eyes, the fox was no longer nearby.`n`n");

			$goldinbank = $session['user']['goldinbank'];
			$stolen = get_module_pref("stolen");

			if ($stolen < $goldinbank) {
				set_module_pref("stolen", $stolen - $goldinbank);
			} else {
				$curse = get_module_pref("curse");
				set_module_pref("stolen", 0);
				set_module_pref("curse", $curse + $stolen - $goldinbank);
			}
			$session['user']['goldinbank'] = 0;

			output("`\$Your debt to the bank was paid off.`n");
			output("`\$Instead, you have an obligation to the fox.`n");
			debuglog("paid off the bank debt with the help of the golden fox");
			addnav("Continue",$from);
		}

		else {
			output("`3Suddenly your body was paralyzed and you were lying motionless on the ground. The fox circled you.`n`n");
			output("`^\"You have no debts to the bank. Were you trying to trick me? That's very unwise.\" ");
			output("`3The fox touched your forehead with its paw and muttered some spell, and then you lost consciousness.`n`n");
			output("`3When you opened your eyes, your all gold was gone, and the fox was no longer nearby.`n`n");

			$lost_gold = $session['user']['gold'];
			if ($lost_gold > 0) {
				$session['user']['gold'] = 0;
				output("`\$You lose %d gold!`n", $lost_gold);
				debuglog("lost $lost_gold gold to the golden fox");
			}

			addnav("Continue",$from);
		}
	}

	else {
		output("`3You returned to the forest.");
		addnav("Continue",$from);
	}

	page_footer();
}
